--[[
Copyright (C) GtX (Andy), 2020

Author: GtX | Andy
Date: 05.05.2020
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

MultiplayerVehicleKeysSetOwnerEvent = {}

local MultiplayerVehicleKeysSetOwnerEvent_mt = Class(MultiplayerVehicleKeysSetOwnerEvent, Event)
InitEventClass(MultiplayerVehicleKeysSetOwnerEvent, "MultiplayerVehicleKeysSetOwnerEvent")

function MultiplayerVehicleKeysSetOwnerEvent.emptyNew()
    local self = Event.new(MultiplayerVehicleKeysSetOwnerEvent_mt)

    return self
end

function MultiplayerVehicleKeysSetOwnerEvent.new(object, userId, showNotification)
    local self = MultiplayerVehicleKeysSetOwnerEvent.emptyNew()

    self.object = object
    self.userId = userId
    self.showNotification = showNotification

    return self
end

function MultiplayerVehicleKeysSetOwnerEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)

    if streamReadBool(streamId) then
        self.userId = streamReadInt8(streamId)
    end

    self.showNotification = streamReadBool(streamId)

    self:run(connection)
end

function MultiplayerVehicleKeysSetOwnerEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)

    if streamWriteBool(streamId, self.userId ~= nil) then
        streamWriteInt8(streamId, self.userId)
    end

    streamWriteBool(streamId, self.showNotification)
end

function MultiplayerVehicleKeysSetOwnerEvent:run(connection)
    if self.userId ~= nil then
        self.object:addKeyOwner(self.userId, self.showNotification, true)
    else
        self.object:removeKeyOwner(self.showNotification, true)
    end

    if not connection:getIsServer() then
        g_server:broadcastEvent(MultiplayerVehicleKeysSetOwnerEvent.new(self.object, self.userId, self.showNotification), nil, connection, self.object)
    end
end

function MultiplayerVehicleKeysSetOwnerEvent.sendEvent(object, userId, showNotification, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(MultiplayerVehicleKeysSetOwnerEvent.new(object, userId, showNotification), nil, nil, object)
        else
            g_client:getServerConnection():sendEvent(MultiplayerVehicleKeysSetOwnerEvent.new(object, userId, showNotification))
        end
    end
end
